//----------------------------------------------------------------------------------------
// Prints a list of ODBC data sources and associated descriptions
//
//----------------------------------------------------------------------------------------

#define ODBCVER 0x0250                        // define ODBC API version 2.5
#ifdef __OS2__
#include  "win2os2.h"
#endif

#include <sql.h>
#include <sqlext.h>

int main(int argc, char *argv[])
{
    HENV    henv;                              // environment handle
    RETCODE rc;                                // error return code
    UCHAR   dsName[SQL_MAX_DSN_LENGTH+1];      // name of the data source
    SWORD   dsNameLen;                         // holds length of data source name returned by function
    UCHAR   dsDesc[257];                       // description of data source
    SWORD   dsDescLen;                         // holds length of data source description returned by function

    rc = SQLAllocEnv(&henv);                   // allocate the ODBC environment
    if (rc == SQL_ERROR)
    {
        printf("Error allocating environment\n");
        return -1;
    }


    //  fetch all the data sources defined on this system
    while (
            SQLDataSources(henv,SQL_FETCH_NEXT,dsName,
            (SWORD) (SQL_MAX_DSN_LENGTH), &dsNameLen, dsDesc,  256, &dsDescLen)
            != SQL_NO_DATA_FOUND
          )
    {
        printf("DSN: %s  Desc: %s\n",dsName, dsDesc);
    }

    return 0;
}