//----------------------------------------------------------------------------------------
// Connects to an ODBC data source
//----------------------------------------------------------------------------------------
#define ODBCVER 0x0250                        // define ODBC API version 2.5
#ifdef __OS2__
#include  "win2os2.h"
#endif
#include <sql.h>
#include <sqlext.h>

void print_err(HENV henv, HDBC hdbc, HSTMT hstmt, RETCODE xrc);

int main(int argc, char *argv[])
{
    HENV    henv;                              // environment handle
    HDBC    hdbc;                              // connection handle
    RETCODE rc;                                // error return code

    rc = SQLAllocEnv(&henv);                   // allocate the ODBC environment
    if (rc==SQL_ERROR)
    {
      printf("Error allocating environment\n");
      return -1;
    }

    rc = SQLAllocConnect(henv, &hdbc);          // allocate connection handlec
    if ((rc != SQL_SUCCESS) & (rc != SQL_SUCCESS_WITH_INFO))
    {
        print_err(henv, SQL_NULL_HDBC, SQL_NULL_HSTMT,rc);
        return -1;
    }

    // Connect to the data source
    rc = SQLConnect(hdbc, "dbase_xmp", SQL_NTS, NULL, SQL_NTS, NULL, SQL_NTS);
    if (rc != SQL_SUCCESS & rc != SQL_SUCCESS_WITH_INFO)
    {
        print_err(henv, hdbc, SQL_NULL_HSTMT,rc);
        return -1;
    }
    printf("Connected!\n");
    return 0;
}

void print_err(HENV henv, HDBC hdbc, HSTMT hstmt, RETCODE xrc)
{
    RETCODE	rc=0;	                  // general return code for API
    UCHAR	szSqlState[SQL_MAX_MESSAGE_LENGTH];    //  SQL state string
    SDWORD	pfNativeError;          // Native error code
    UCHAR	szErrorMsg[SQL_MAX_MESSAGE_LENGTH];   // Error msg text buffer pointer
    SWORD	pcbErrorMsg;            // Error msg text Available bytes

    // --- retrieve text from error message ----
    rc = SQLError(henv,hdbc, hstmt, szSqlState,
         &pfNativeError, szErrorMsg, SQL_MAX_MESSAGE_LENGTH-1, &pcbErrorMsg);
    if (rc == SQL_SUCCESS)
    {
         printf("##Error SQLSTATE: %s.  Error code: %ld  %s\n", szSqlState, pfNativeError, szErrorMsg);
    }
}