//----------------------------------------------------------------------------------------
// Connects to an ODBC data source
//
//----------------------------------------------------------------------------------------

#define ODBCVER 0x0250                        // define ODBC API version 2.5
#ifdef __OS2__
#include  "win2os2.h"
#endif

#include <sql.h>
#include <sqlext.h>
void listTables(HENV henv, HDBC hdbc);
void print_err(HENV henv, HDBC hdbc, HSTMT hstmt, RETCODE xrc);

int main(int argc, char *argv[])
{
    HENV    henv;                              // environment handle
    HDBC    hdbc;                              // connection handle
    RETCODE rc;                                // error return cod
    UCHAR   rtValue[SQL_MAX_MESSAGE_LENGTH+1]; // storage space for SQLGetInfo
    SWORD   rtlen;


    rc = SQLAllocEnv(&henv);                   // allocate the ODBC environment
    if (rc==SQL_ERROR)
    {
      printf("Error allocating environment\n");
      return -1;
    }

    rc = SQLAllocConnect(henv, &hdbc);          // allocate connection handlec
    if ((rc != SQL_SUCCESS) & (rc != SQL_SUCCESS_WITH_INFO))
    {
        print_err(henv, SQL_NULL_HDBC, SQL_NULL_HSTMT,rc);
        return -1;
    }

    // Connect to the data source
    rc = SQLConnect(hdbc, "sqlany", SQL_NTS, "dba", SQL_NTS, "sql", SQL_NTS);
    if (rc != SQL_SUCCESS & rc != SQL_SUCCESS_WITH_INFO)
    {
        print_err(henv, hdbc, SQL_NULL_HSTMT,rc);
        return -1;
    }
    printf("Connected!\n");

    rc = SQLGetInfo(hdbc, SQL_DBMS_NAME, rtValue,(SWORD) sizeof(rtValue), &rtlen);
    printf("Database name: %s\n" , rtValue);
    rc = SQLGetInfo(hdbc, SQL_USER_NAME, rtValue,(SWORD) sizeof(rtValue), &rtlen);
    printf("User name:   : %s\n" , rtValue);
    rc = SQLGetInfo(hdbc, SQL_OWNER_TERM, rtValue,(SWORD) sizeof(rtValue), &rtlen);
    printf("Owner term   : %s\n" , rtValue);
    rc = SQLGetInfo(hdbc, SQL_PROCEDURES, rtValue, (SWORD) sizeof(rtValue), &rtlen);
    printf("Procedures   : %s\n" , rtValue);

    listTables(henv,hdbc);

    return 0;
}

void listTables(HENV henv, HDBC hdbc)
{
   HSTMT    hstmt;
   RETCODE  rc;

   UCHAR    qual[129] = "%";
   UCHAR    owner[129] = "%";
   UCHAR    name[129] = "%";
   UCHAR    type[129] = "TABLE";
   UCHAR    remarks[255] = "\0";

   SDWORD   szName;
   SDWORD   szRemarks;
   SDWORD   szOwner;
   SDWORD   szType;
   SDWORD   szQual;

   rc = SQLAllocStmt(hdbc, &hstmt);
   if (rc != SQL_SUCCESS & rc != SQL_SUCCESS_WITH_INFO)
   {
       print_err(henv, hdbc, SQL_NULL_HSTMT,rc);
       return;
   }
   rc = SQLTables(hstmt, NULL, 0, owner, SQL_NTS,
                  name, SQL_NTS, type, SQL_NTS);
   if (rc != SQL_SUCCESS & rc != SQL_SUCCESS_WITH_INFO)
   {
       print_err(henv, hdbc, hstmt,rc);
       return;
   }

   SQLBindCol(hstmt, 1,SQL_C_CHAR,  qual    , 129  ,&szQual);
   SQLBindCol(hstmt, 2,SQL_C_CHAR,  owner   , 129  ,&szOwner);
   SQLBindCol(hstmt, 3,SQL_C_CHAR,  name    , 128  ,&szName);
   SQLBindCol(hstmt, 4,SQL_C_CHAR,  type    , 129  ,&szType);
   SQLBindCol(hstmt, 5,SQL_C_CHAR,  remarks , 256  ,&szRemarks);

   printf("\n%-8.8s %-26.26s %-6.6s %-30.30s\n","Owner","Name","Type","Remarks");
   printf("\n%-8.8s %-26.26s %-6.6s %-30.30s\n","-----","----","----","-------");
   while (1)
   {
      remarks[0] = '\0';
      rc =  SQLFetch(hstmt);
      if (rc == SQL_NO_DATA_FOUND) break;
      if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO)) break;
      printf("%-8.8s %-26.26s %-6.6s %-30.30s\n",owner,name,type,remarks);
   }
   SQLFreeStmt(hstmt, SQL_DROP);           // free the statement handle
}

void print_err(HENV henv, HDBC hdbc, HSTMT hstmt, RETCODE xrc)
{
    RETCODE	rc=0;	                  // general return code for API
    UCHAR	szSqlState[SQL_MAX_MESSAGE_LENGTH];    //  SQL state string
    SDWORD	pfNativeError;          // Native error code
    UCHAR	szErrorMsg[SQL_MAX_MESSAGE_LENGTH];   // Error msg text buffer pointer
    SWORD	pcbErrorMsg;            // Error msg text Available bytes

    // --- retrieve text from error message ----
    rc = SQLError(henv,hdbc, hstmt, szSqlState,
         &pfNativeError, szErrorMsg, SQL_MAX_MESSAGE_LENGTH-1, &pcbErrorMsg);
    if (rc == SQL_SUCCESS)
    {
         printf("##Error SQLSTATE: %s.  Error code: %ld  %s\n", szSqlState, pfNativeError, szErrorMsg);
    }
}