//----------------------------------------------------------------------------------------
// Connects to an ODBC data source
//
//----------------------------------------------------------------------------------------

#define ODBCVER 0x0250                        // define ODBC API version 2.5
#ifdef __OS2__
#include  "win2os2.h"
#endif

#include <sql.h>
#include <sqlext.h>
void  displayData(HENV henv,HDBC hdbc, char sqlStr[]);
void print_err(HENV henv, HDBC hdbc, HSTMT hstmt, RETCODE xrc);

int main(int argc, char *argv[])
{
   HENV    henv;                              // environment handle
   HDBC    hdbc;                              // connection handle
   RETCODE rc;                                // error return cod
   UCHAR   rtValue[SQL_MAX_MESSAGE_LENGTH+1]; // storage space for SQLGetInfo
   SWORD   rtlen;
   HSTMT   hstmt;

   rc = SQLAllocEnv(&henv);                   // allocate the ODBC environment
   if (rc==SQL_ERROR)
   {
     printf("Error allocating environment\n");
     return -1;
   }

   rc = SQLAllocConnect(henv, &hdbc);          // allocate connection handlec
   if ((rc != SQL_SUCCESS) & (rc != SQL_SUCCESS_WITH_INFO))
   {
       print_err(henv, SQL_NULL_HDBC, SQL_NULL_HSTMT,rc);
       return -1;
   }

   // Connect to the data source
   rc = SQLConnect(hdbc, "dbase_xmp", SQL_NTS, NULL, SQL_NTS, NULL, SQL_NTS);
   if (rc != SQL_SUCCESS & rc != SQL_SUCCESS_WITH_INFO)
   {
       print_err(henv, hdbc, SQL_NULL_HSTMT,rc);
       return -1;
   }
   printf("Connected!\n");

   rc = SQLAllocStmt(hdbc,&hstmt);
   rc = SQLExecDirect(hstmt,"insert into names values('Doug','Clark')",SQL_NTS);
   rc = SQLExecDirect(hstmt,"insert into names values('Cathy','Clark')",SQL_NTS);
   rc = SQLExecDirect(hstmt,"insert into names values('Louis','Clark')",SQL_NTS);
   rc = SQLExecDirect(hstmt,"insert into names values('Nightengale','Clark')",SQL_NTS);

   displayData(henv,hdbc,"select fname,lname from names");
   return 0;
}
void  displayData(HENV henv,HDBC hdbc, char sqlStr[])
{
   HSTMT    hstmt;
   RETCODE  rc;
   SWORD    resultCols;
   char     fname[32];
   SDWORD   fNameLen;
   char     lname[32];
   SDWORD   lNameLen;

   rc = SQLAllocStmt(hdbc,&hstmt);
   rc = SQLExecDirect(hstmt, sqlStr, SQL_NTS);
   if (rc != SQL_SUCCESS)
   {
      if (rc == SQL_NO_DATA_FOUND)  printf("No data in table\n");
      else                          print_err(henv, hdbc, hstmt,rc);
      SQLFreeStmt(hstmt,SQL_DROP);
      return;
   }
   rc = SQLNumResultCols(hstmt, &resultCols);
   if (resultCols == 0)
   {
       SQLFreeStmt(hstmt,SQL_DROP);
       printf("No Columns returned \n");
       return;
   }
   rc = SQLBindCol(hstmt,1,SQL_C_CHAR,fname,32,&fNameLen);
   rc = SQLBindCol(hstmt,2,SQL_C_CHAR,lname,32,&lNameLen);
   while(1)
   {
      rc = SQLFetch(hstmt);
      if (rc != SQL_SUCCESS)  break;
      printf("%s  %s\n",fname,lname);
   }
}

void print_err(HENV henv, HDBC hdbc, HSTMT hstmt, RETCODE xrc)
{
    RETCODE	rc=0;	                  // general return code for API
    UCHAR	szSqlState[SQL_MAX_MESSAGE_LENGTH];    //  SQL state string
    SDWORD	pfNativeError;          // Native error code
    UCHAR	szErrorMsg[SQL_MAX_MESSAGE_LENGTH];   // Error msg text buffer pointer
    SWORD	pcbErrorMsg;            // Error msg text Available bytes

    // --- retrieve text from error message ----
    rc = SQLError(henv,hdbc, hstmt, szSqlState,
         &pfNativeError, szErrorMsg, SQL_MAX_MESSAGE_LENGTH-1, &pcbErrorMsg);
    if (rc == SQL_SUCCESS)
    {
         printf("##Error SQLSTATE: %s.  Error code: %ld  %s\n", szSqlState, pfNativeError, szErrorMsg);
    }
}