import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ButtonDemo extends JFrame implements ActionListener {
    private JButton leftButton;
    private JButton middleButton;
    private JButton rightButton;

    private String leftButtonImageName = "right.gif";
    private String middleButtonImageName = "middle.gif";
    private String rightButtonImageName = "left.gif";

    /* Constructor */
    public ButtonDemo() {
        setTitle("ButtonDemo");
        setSize(600, 80);

        Toolkit tk = Toolkit.getDefaultToolkit();

        /*
         * Find the middle position on the screen, all screen sizes.
         */
        Dimension dim = tk.getScreenSize();
        int w = (dim.width - 600) / 2;
        int h = (dim.height - 80) / 2;
        /* Are there such small screens around? If so... */
        if (w < 0 || h < 0) {
            w = 0;
            h = 0;
        }
        setLocation(w, h);

        /*
         * Construct an icon to the frame
         */
        Image img = tk.getImage("chicken.gif");
        setIconImage(img);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        getContentPane().add(makeContent(), "Center");
    }

    /*
     * A helper method that makes the code clearer. Not this time but
     * when there are lots of panels the constructor code becomes
     * clearer, and it will be much easier to add / change to a
     * certain panel.
     */
    private Container makeContent() {
        /*
         * Some code to get the button images. This code can easily
         * be concatenated but this clearifies what's going on.
         */
        ImageIcon leftButtonIcon;   // only the declarations
        ImageIcon middleButtonIcon;
        ImageIcon rightButtonIcon;

        leftButtonIcon = new ImageIcon(leftButtonImageName);
        middleButtonIcon = new ImageIcon(middleButtonImageName);
        rightButtonIcon = new ImageIcon(rightButtonImageName);

        /*
         * Construct the JButtons with the icons
         */
        leftButton = new JButton("Disable middle button",
                                 leftButtonIcon);

        middleButton = new JButton("Middle button",
                                   middleButtonIcon);

        rightButton = new JButton("Enable middle button",
                                  rightButtonIcon);
        rightButton.setEnabled(false);

        /*
         * Listeners for left and right buttons.
         */
        leftButton.addActionListener(this);
        rightButton.addActionListener(this);

        /*
         * The convenient flyover help bubbles.
         */
        leftButton.setToolTipText("Click this button to disable the"
            + " middle button.");
        middleButton.setToolTipText("This middle button does nothing"
            + " when you click it.");
        rightButton.setToolTipText("Click this button to enable the"
            + " middle button.");

        /*
         * Make a JPanel and add the components to it.
         */
        JPanel pane = new JPanel();
        pane.add(leftButton);
        pane.add(middleButton);
        pane.add(rightButton);
        pane.setBackground(new Color(255, 0, 0));

        return pane;
    }

    public void actionPerformed(ActionEvent e) {
        Object eComp = e.getSource();
        if (eComp == leftButton) {
            leftButton.setEnabled(false);
            middleButton.setEnabled(false);
            rightButton.setEnabled(true);
        } else if (eComp == rightButton) {
            leftButton.setEnabled(true);
            middleButton.setEnabled(true);
            rightButton.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        ButtonDemo frame = new ButtonDemo();
        frame.show();
    }
}

// Modelled from SUN's Java Tutorial, with gratitude
