/* Search engine query program */
crlf=d2c(13)||d2c(10)          /* Carriage return - linefeed pair */
Site = "www.altavista.digital.com"
SiteCommand = "GET /cgi-bin/query?pg=q&what=web&q="
SearchString = "OS/2 Supersite"
UserAgent = "User-Agent: OS/2 REXX Query Program 1.0"  /* The name of our program */

Call CreateQuery /* Create the query */
Say Query
Exit

/* Create the query string to be sent to the web server */
CreateQuery:

/* Only allow the routine to see the necessary variables */
Procedure Expose SiteCommand SearchString UserAgent Query crlf

/* Create a list of the types of responses we can handle */
Accept = "Accept: text/plain"||crlf||"Accept: text/html"||crlf

SearchStringEncoded = Encode(SearchString) /* Last month's code */

Query = SiteCommand||SearchStringEncoded "HTTP/1.0"||crlf||Accept
Query = Query || UserAgent || crlf || crlf

Return

/* Encoder routine for URLs */
Encode:
Procedure
Parse Arg AString
OkayChars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'
NewString=""

Do i = 1 to Length( AString)
   Test = SubStr( AString, i, 1)
   if Pos( Test, OkayChars) > 0
      Then NewString = NewString || Test
   else Do 
      If Test=" "
         Then NewString=NewString||"+"
      Else NewString = NewString || '%' || c2x( Test)
   end
end
Return NewString

