/*
 * SpeechQ.CMD
 *
 * This program runs in the background and waits for data to be placed in the
 * queue 'REXXSPEECH'.  When data is encountered, RSynth is used to
 * speak the text.
 *
 * The following text strings have special meanings:
 * COMMAND_END - program terminates
 * COMMAND_MUTE - discards all pending strings all future strings
 * COMMAND_UNMUTE - cancels effects of COMMAND_MUTE
 * COMMAND_DISCARD - removes all pending strings from queue
 * COMMAND_NUMQUEUED - speaks the number of messages queued
 *
 */

queuename='REXXSPEECH'
synthfilename='SAY.EXE'
synth='SAY'
parse source . . sourcename
speechdir = filespec('D', sourcename)||filespec('P', sourcename)
speechdir = left(sourcedir, length(sourcedir)-1)
call directory speechdir

call rxfuncadd 'SysSleep','RexxUtil','SysSleep'
call rxfuncadd 'SysFileTree','RexxUtil','SysFileTree'

call SysFileTree synthfilename, file, 'FO'
if file.0 = 0 then
	do
	say synthfilename' not found!  Speech queue terminated.'
 	say '(This program should be in the same directory as 'synthfilename'.)'
	say
	say 'Press Enter to quit.'
	pull
	exit
	end

rc = rxqueue('Create', queuename)
if (rc \= queuename) then
	do
	rc = rxqueue('Delete', queuename)
	rc = rxqueue('Create', queuename)
	end

if (rc = queuename) then
	do
	rc = rxqueue('Set', queuename)
	synth '"Speech enabled."'

	muted = 0
	paused = 0
	call checkqueue
	do while curspeech\='COMMAND_END'
		select
		when (curspeech='COMMAND_MUTE') then
			do
			if muted=1 then
				synth '"Speech is already muted."'
			else
				do
				muted=1
				synth '"Speech muted."'
				end
			end
		when (curspeech='COMMAND_UNMUTE') then
			do
			if muted=0 then
				synth '"Speech is not muted."'
			else
				do
			 	muted=0
				synth '"Speech resumed."'
			end
			end
		when (curspeech='COMMAND_DISCARD') then
			do while queued()>0
				pull
				end
		when (curspeech='COMMAND_NUMQUEUED') then
			do
			if queued()=0 then
				synth '"No messages are queued."'
			else if queued()=1 then
				synth '"There is one message queued."'
			else
				synth '"There are 'queued()' messages queued."'
			end
		otherwise
			if (muted = 0) then
				synth '"'curspeech'"'
			else
				say 'Muted: 'curspeech
		end /* select */
		call checkqueue
		end /* do */

	rc = rxqueue('Delete', queuename)
	synth '"Speech terminated."'
	end
else
	synth '"Unable to delete pre-existing speech queue.  Aborting."'

exit

checkqueue: procedure expose curspeech paused
	say 'Queued: 'queued()
	/* Use LINEIN() instead of PULL so we don't have to busy-wait on QUEUED() */
        curspeech = linein('QUEUE:')
	return