/*
 * SpkMail.CMD
 *
 * This program interfaces a email program with the speech queue.  The email
 * program should be set up to call this program every time a new message
 * arrives.  The full pathname of the message should be passed on the command
 * line.  When called, this program will parse out the "From:" and "Subject:"
 * lines of the message, convert them to a computer-readable format, and place
 * them on the speech queue.
 *
 * If your mailer doesn't pass the full pathname, edit the 'pathstem' variable
 * (below) to include the drive letter and directory the new mail files are
 * placed into.
 *
 * UNIX_DOS.EXE is expected to be in the same directory as this program.
 * This program is used to ensure that all the lines of a message end with
 * a carriage return and line feed, which is required for REXX to recognize
 * individual lines.
 *
 */

queuename='REXXSPEECH'
pathstem='F:\MR2ICE'

parse arg mailfile
mailfile=pathstem'\'mailfile

call rxfuncadd 'SysFileSearch','RexxUtil','SysFileSearch'
call rxfuncadd 'SysFileTree','RexxUtil','SysFileTree'
rc = rxqueue('Set', queuename)

/* Find unix_dos */
parse source . . sourcename
sourcedir = filespec('D', sourcename)||filespec('P', sourcename)
say sourcedir||unix_dos.exe
call SysFileTree sourcedir||'unix_dos.exe', file, 'FO'
if file.0 = 0 then
	do
	queue 'New Mail dot CMD has failed.  It can''t find Unix_DOS dot EXE.  Press Enter to exit.'
	say 'NewMail.CMD has failed.  It can''t find Unix_DOS.EXE.'
	say 'Press Enter to exit...'
	call linein
	exit
	end

file.1 '-u "'mailfile'"'

/* Parse out "From" and "Subject" lines */
call SysFileSearch 'From:', mailfile, fromfile
call SysFileSearch 'Subject:', mailfile, subjectfile
parse var fromfile.1 'From:' from
parse var subjectfile.1 'Subject:' subject

/* Convert to "From" and "Subject" lines readable format */
badchar=1
do until badchar=0
	badchar=0
	charpos=lastpos('.', from)
	if charpos>0 then do
		from = overlay(' ', from, charpos)
		from = insert('dot ', from, charpos)
		badchar = 1
	end
end

badchar=1
do until badchar=0
	badchar = 0
	charpos=lastpos('<', from)
	if charpos>0 then do
		from=overlay('.', from, charpos)
		from=insert(' ', from, charpos)
		badchar = 1
	end
	charpos=lastpos('>', from)
	if charpos>0 then do
		from=overlay('.', from, charpos)
		from=insert(' ', from, charpos)
		badchar = 1
	end
	charpos=lastpos('(', from)
	if charpos>0 then do
		from=overlay('.', from, charpos)
		from=insert(' ', from, charpos)
		badchar = 1
	end
	charpos=lastpos(')', from)
	if charpos>0 then do
		from=overlay('.', from, charpos)
		from=insert(' ', from, charpos)
		badchar = 1
	end
end
		
if from='' then 
	from='someone with no address'
if subject='' then
	subject='blank'

/* Speak */
queue '"You have received e-mail from 'from'.  The subject is 'subject'."'

exit
