/* Routine to replace all occurences of a string with another
   in a specified set of files
 
   Author: Dirk Terrell     Version of April 3 1996
 
   Usage:
         replall files separator target (separator) replace
 
   Example:
         replall *.html $ http: $ ftp:
         would replace "http:" with "ftp:" in all files with
         an extension of html.

   Uses:
         rxmulch.cmd
*/

/* Register REXXUTIL functions */
call rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call sysloadfuncs

/* Parse the command line */
Parse Arg FileSpec Separator Rest
If Length(Separator)<>1 then do
   Say 
   Say "Argument 2 must be the separator character."
   Exit
end  /* Do */
Parse Var Rest Target (Separator) Replace

/* Eliminate leading and trailing spaces */
Replace=Strip(Replace) 
Target=Strip(Target)

/* Escape the "@" character properly because it is the special character in RXMulch */
Target=RXMulch(Target,"/C.@@.@@@@.")
Replace=RXMulch(Replace,"/C.@@.@@@@.")

/* Get the list of files */
rc=SysFileTree(FileSpec,"File.","OF")

/* Now loop over the files and process them */
Do i=1 to File.0
   Say "Processing file" i "of" File.0 " " File.i
   BackupFile.i=File.i||".bak"
   "@copy" File.i BackupFile.i "1>nul"
   If rc=0 then 
      rc=SysFileDelete(File.i)
   Else Do
      Say "Could not back up" File.i "exiting..."
      Exit
   end  /* Do */
   Call RxMulch BackupFile.i File.i "/C"||Separator||Target||Separator||Replace||Separator
   rc=Stream(File.i,"C","Query Size")
   If rc="" then
      "@copy" BackupFile.i File.i "1>nul"
end /* do */
Exit
